/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.peripherals.keyboards;

import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyCaps;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class KeyboardBlock
extends class_2237 {
    public static final class_2753 FACING = class_2318.field_10927;
    protected static final class_265 SHAPE = class_2248.method_9541((double)5.0, (double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0);

    public KeyboardBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public void openScreen(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        class_3908 screenHandlerFactory;
        if (!world.field_9236 && (screenHandlerFactory = state.method_26196(world, pos)) != null) {
            player.method_17355(screenHandlerFactory);
        }
    }

    @Nonnull
    public final class_1269 method_9534(@Nonnull class_2680 state, class_1937 world, @Nonnull class_2338 pos, @Nonnull class_1657 player, @Nonnull class_1268 hand, @Nonnull class_3965 hit) {
        class_1269 class_12692;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof KeyboardTile) {
            KeyboardTile kbTile = (KeyboardTile)tile;
            class_12692 = kbTile.onActivate(player, hand, hit);
        } else {
            class_12692 = class_1269.field_5811;
        }
        return class_12692;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042().method_10153();
        if (direction == class_2350.field_11033 || direction == class_2350.field_11036) {
            direction = class_2350.field_11043;
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction);
    }

    public KeyboardTile getKBTile(class_1937 world, class_2338 pos) {
        return (KeyboardTile)world.method_8321(pos);
    }

    public KeyCaps getKeyCaps(class_1922 view, class_2338 pos) {
        KeyCaps keyCapsToReturn;
        class_2586 kb_tile = view.method_8321(pos);
        if (kb_tile instanceof KeyboardTile && (keyCapsToReturn = ((KeyboardTile)kb_tile).keyCaps) != null) {
            return keyCapsToReturn;
        }
        return new KeyCaps();
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        KeyCaps itemKeyCaps;
        class_2586 blockEntity;
        if (itemStack.method_7938() && (blockEntity = world.method_8321(pos)) instanceof KeyboardTile) {
            ((KeyboardTile)blockEntity).setCustomName(itemStack.method_7964());
        }
        if ((blockEntity = world.method_8321(pos)) instanceof KeyboardTile && (itemKeyCaps = KeyCaps.fromItemStack(itemStack)) != null) {
            ((KeyboardTile)blockEntity).keyCaps = itemKeyCaps;
        }
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return KeyboardBlock.rotateShape(class_2350.field_11034, direction, SHAPE);
    }

    public class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KeyboardTile(pos, state);
    }

    @Nonnull
    public class_2464 method_9604(@Nonnull class_2680 state) {
        return class_2464.field_11458;
    }
}

